using System;

namespace gov.va.med.vbecs.Common
{
	#region Header
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	/// <Developers>
	/// 	<Developer>Carrie Van Stedum</Developer>
	/// </Developers>
	/// <SiteName>Hines OIFO</SiteName>
	/// <CreationDate>01/27/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Summary description for DataItem.
	/// </summary>
	#endregion

	public class DataItem
	{
		private string _id;
		private string _value;



		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8112"> 
		///		<ExpectedInput>id, value</ExpectedInput>
		///		<ExpectedOutput>DataItem class</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8113"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Class used to set the display proeprty of a combo/list box but have a different value encapsulated
		/// </summary>
		/// <param name="id"></param>
		/// <param name="value"></param>
		public DataItem(string id, string value)
		{
			_id = id;
			_value = value;
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8114"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8115"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the string representing the Id of this DataItem
		/// </summary>
		public string ID
		{
			get
			{
				return this._id;
			}
		} 


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8116"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8117"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Value -- string value to store
		/// </summary>
		public string Value
		{
			get
			{
				return this._value;
			}
		} 

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8118"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8119"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Willl show the this.Value property value -- text displayed to user when object placed in control
		/// </summary>
		/// <returns></returns>
		public override string ToString() 
		{
			return Value;
		}
	}
}
